<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TherapistEducation extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "therapist_educations";
    protected $fillable = ['therapist_id', 'institute','degree','subject','description', 'from', 'to', 'image', 'is_active', 'deleted_at'];
    protected $casts = [
        'from' => 'datetime',
        'to' => 'datetime',
    ];

    public function scopeWithAll($query)
    {
        return $query->with('therapist');
    }
    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }

    public function therapist()
    {
        return $this->belongsTo(Therapist::class);
    }

}
